<?php
/* --------------------------------------------------------------
   ProcessedImageInformation.php 2023-01-26
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2023 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\ImageProcessing\Model;

/**
 * Class ProcessedImageInformation
 *
 * @package Gambio\Admin\Modules\ImageProcessing\Model
 */
class ProcessedImageInformation
{
    public function __construct(
        private string $source,
        private string $destination,
        private int    $maxWidth,
        private int    $maxHeight,
        private int    $imageWidth,
        private int    $imageHeight,
        private int    $imageType,
        private int    $finalWidth,
        private int    $finalHeight
    ) {
    }
    
    
    /**
     * @return string
     */
    public function source(): string
    {
        return $this->source;
    }
    
    
    /**
     * @return string
     */
    public function destination(): string
    {
        return $this->destination;
    }
    
    
    /**
     * @return int
     */
    public function maxWidth(): int
    {
        return $this->maxWidth;
    }
    
    
    /**
     * @return int
     */
    public function maxHeight(): int
    {
        return $this->maxHeight;
    }
    
    
    /**
     * @return int
     */
    public function imageWidth(): int
    {
        return $this->imageWidth;
    }
    
    
    /**
     * @return int
     */
    public function imageHeight(): int
    {
        return $this->imageHeight;
    }
    
    
    /**
     * @return int
     */
    public function imageType(): int
    {
        return $this->imageType;
    }
    
    
    /**
     * @return int
     */
    public function finalWidth(): int
    {
        return $this->finalWidth;
    }
    
    
    /**
     * @return int
     */
    public function finalHeight(): int
    {
        return $this->finalHeight;
    }
}